---@meta

---@class AGameplayDebuggerCategoryReplicator : AActor
---@field OwnerPC APlayerController
---@field bIsEnabled boolean
---@field ReplicatedData FGameplayDebuggerNetPack
---@field DebugActor FGameplayDebuggerDebugActor
---@field VisLogSync FGameplayDebuggerVisLogSync
---@field RenderingComp UGameplayDebuggerRenderingComponent
local AGameplayDebuggerCategoryReplicator = {}

---@param InViewLocation FVector
---@param InViewDirection FVector
function AGameplayDebuggerCategoryReplicator:ServerSetViewPoint(InViewLocation, InViewDirection) end
---@param bEnable boolean
function AGameplayDebuggerCategoryReplicator:ServerSetEnabled(bEnable) end
---@param Actor AActor
---@param bSelectInEditor boolean
function AGameplayDebuggerCategoryReplicator:ServerSetDebugActor(Actor, bSelectInEditor) end
---@param CategoryId int32
---@param bEnable boolean
function AGameplayDebuggerCategoryReplicator:ServerSetCategoryEnabled(CategoryId, bEnable) end
---@param ExtensionId int32
---@param HandlerId int32
function AGameplayDebuggerCategoryReplicator:ServerSendExtensionInputEvent(ExtensionId, HandlerId) end
---@param CategoryId int32
---@param HandlerId int32
function AGameplayDebuggerCategoryReplicator:ServerSendCategoryInputEvent(CategoryId, HandlerId) end
function AGameplayDebuggerCategoryReplicator:ServerResetViewPoint() end
function AGameplayDebuggerCategoryReplicator:OnRep_ReplicatedData() end
---@param Params FGameplayDebuggerDataPackRPCParams
function AGameplayDebuggerCategoryReplicator:ClientDataPackPacket(Params) end


---@class AGameplayDebuggerPlayerManager : AActor
---@field PlayerData TArray<FGameplayDebuggerPlayerData>
---@field PendingRegistrations TArray<AGameplayDebuggerCategoryReplicator>
local AGameplayDebuggerPlayerManager = {}



---@class FGameplayDebuggerCategoryConfig
---@field CategoryName FString
---@field SlotIdx int32
---@field ActiveInGame EGameplayDebuggerOverrideMode
---@field ActiveInSimulate EGameplayDebuggerOverrideMode
---@field Hidden EGameplayDebuggerOverrideMode
---@field bOverrideSlotIdx boolean
---@field InputHandlers TArray<FGameplayDebuggerInputConfig>
local FGameplayDebuggerCategoryConfig = {}



---@class FGameplayDebuggerCategoryData
---@field CategoryName FName
---@field TextLines TArray<FString>
---@field Shapes TArray<FGameplayDebuggerShape>
---@field DataPacks TArray<FGameplayDebuggerDataPackHeader>
---@field bIsEnabled boolean
local FGameplayDebuggerCategoryData = {}



---@class FGameplayDebuggerDataPackHeader
---@field DataVersion int16
---@field SyncCounter int16
---@field DataSize int32
---@field DataOffset int32
---@field bIsCompressed boolean
local FGameplayDebuggerDataPackHeader = {}



---@class FGameplayDebuggerDataPackRPCParams
---@field CategoryName FName
---@field DataPackIdx int32
---@field Header FGameplayDebuggerDataPackHeader
---@field Data TArray<uint8>
local FGameplayDebuggerDataPackRPCParams = {}



---@class FGameplayDebuggerDebugActor
---@field Actor TWeakObjectPtr<AActor>
---@field ActorName FName
---@field SyncCounter int16
local FGameplayDebuggerDebugActor = {}



---@class FGameplayDebuggerExtensionConfig
---@field ExtensionName FString
---@field UseExtension EGameplayDebuggerOverrideMode
---@field InputHandlers TArray<FGameplayDebuggerInputConfig>
local FGameplayDebuggerExtensionConfig = {}



---@class FGameplayDebuggerInputConfig
---@field ConfigName FString
---@field Key FKey
---@field bModShift boolean
---@field bModCtrl boolean
---@field bModAlt boolean
---@field bModCmd boolean
local FGameplayDebuggerInputConfig = {}



---@class FGameplayDebuggerNetPack
---@field Owner AGameplayDebuggerCategoryReplicator
---@field SavedData TArray<FGameplayDebuggerCategoryData>
local FGameplayDebuggerNetPack = {}



---@class FGameplayDebuggerPlayerData
---@field Controller UGameplayDebuggerLocalController
---@field InputComponent UInputComponent
---@field Replicator AGameplayDebuggerCategoryReplicator
local FGameplayDebuggerPlayerData = {}



---@class FGameplayDebuggerShape
---@field ShapeData TArray<FVector>
---@field Description FString
---@field Color FColor
---@field Type EGameplayDebuggerShape
local FGameplayDebuggerShape = {}



---@class FGameplayDebuggerVisLogSync
---@field DeviceIDs FString
local FGameplayDebuggerVisLogSync = {}



---@class UGameplayDebuggerConfig : UObject
---@field ActivationKey FKey
---@field CategoryRowNextKey FKey
---@field CategoryRowPrevKey FKey
---@field CategorySlot0 FKey
---@field CategorySlot1 FKey
---@field CategorySlot2 FKey
---@field CategorySlot3 FKey
---@field CategorySlot4 FKey
---@field CategorySlot5 FKey
---@field CategorySlot6 FKey
---@field CategorySlot7 FKey
---@field CategorySlot8 FKey
---@field CategorySlot9 FKey
---@field DebugCanvasPaddingLeft float
---@field DebugCanvasPaddingRight float
---@field DebugCanvasPaddingTop float
---@field DebugCanvasPaddingBottom float
---@field bDebugCanvasEnableTextShadow boolean
---@field Categories TArray<FGameplayDebuggerCategoryConfig>
---@field Extensions TArray<FGameplayDebuggerExtensionConfig>
local UGameplayDebuggerConfig = {}



---@class UGameplayDebuggerLocalController : UObject
---@field CachedReplicator AGameplayDebuggerCategoryReplicator
---@field CachedPlayerManager AGameplayDebuggerPlayerManager
---@field DebugActorCandidate AActor
---@field HUDFont UFont
local UGameplayDebuggerLocalController = {}



---@class UGameplayDebuggerRenderingComponent : UDebugDrawComponent
local UGameplayDebuggerRenderingComponent = {}


---@class UGameplayDebuggerUserSettings : UDeveloperSettings
---@field bEnableGameplayDebuggerInEditor boolean
---@field MaxViewDistance float
---@field MaxViewAngle float
---@field FontSize int32
local UGameplayDebuggerUserSettings = {}



